/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.grower;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;

public class AncientTreeGrower
extends AbstractTreeGrower {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ANCIENT_TREE = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("alexscaves", "ancient_tree"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> GIANT_ANCIENT_TREE = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("alexscaves", "giant_ancient_tree"));

    public boolean m_213817_(ServerLevel serverLevel, ChunkGenerator chunkGenerator, BlockPos blockPos, BlockState state, RandomSource randomSource) {
        for (int i = 0; i >= -2; --i) {
            for (int j = 0; j >= -2; --j) {
                if (!AncientTreeGrower.isThreeByThreeSapling(state, (BlockGetter)serverLevel, blockPos, i, j)) continue;
                return this.placeMega(serverLevel, chunkGenerator, blockPos, state, randomSource, i, j);
            }
        }
        return super.m_213817_(serverLevel, chunkGenerator, blockPos, state, randomSource);
    }

    public boolean placeMega(ServerLevel serverLevel, ChunkGenerator chunkGenerator, BlockPos blockPos, BlockState blockState, RandomSource randomSource, int x, int z) {
        int j;
        int i;
        ResourceKey<ConfiguredFeature<?, ?>> resourcekey = this.getConfiguredMegaFeature(randomSource);
        if (resourcekey == null) {
            return false;
        }
        Holder holder = (Holder)serverLevel.m_9598_().m_175515_(Registries.f_256911_).m_203636_(resourcekey).orElse(null);
        SaplingGrowTreeEvent event = ForgeEventFactory.blockGrowFeature((LevelAccessor)serverLevel, (RandomSource)randomSource, (BlockPos)blockPos, (Holder)holder);
        holder = event.getFeature();
        if (event.getResult() == Event.Result.DENY) {
            return false;
        }
        if (holder == null) {
            return false;
        }
        ConfiguredFeature configuredfeature = (ConfiguredFeature)holder.m_203334_();
        BlockState blockstate = Blocks.f_50016_.m_49966_();
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                serverLevel.m_7731_(blockPos.m_7918_(x + i, 0, z + j), blockstate, 4);
            }
        }
        if (configuredfeature.m_224953_((WorldGenLevel)serverLevel, chunkGenerator, randomSource, blockPos.m_7918_(x + 1, 0, z + 1))) {
            return true;
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                serverLevel.m_7731_(blockPos.m_7918_(x + i, 0, z + j), blockstate, 4);
            }
        }
        return false;
    }

    public static boolean isThreeByThreeSapling(BlockState state, BlockGetter level, BlockPos pos, int x, int z) {
        Block block = state.m_60734_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                mutableBlockPos.m_122178_(pos.m_123341_() + x + i, pos.m_123342_(), pos.m_123343_() + z + j);
                if (level.m_8055_((BlockPos)mutableBlockPos).m_60713_(block)) continue;
                return false;
            }
        }
        return true;
    }

    protected ResourceKey<ConfiguredFeature<?, ?>> m_213888_(RandomSource randomSource, boolean b) {
        return ANCIENT_TREE;
    }

    private ResourceKey<ConfiguredFeature<?, ?>> getConfiguredMegaFeature(RandomSource randomSource) {
        return GIANT_ANCIENT_TREE;
    }
}

