/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.github.alexmodguy.alexscaves.server.block.NuclearFurnaceComponentBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.NuclearFurnaceBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class NuclearFurnaceBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public NuclearFurnaceBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(5.0f, 1001.0f).m_60918_(ACSoundTypes.NUCLEAR_BOMB).m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new NuclearFurnaceBlockEntity(pos, state);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return NuclearFurnaceBlock.m_152132_(entityType, (BlockEntityType)((BlockEntityType)ACBlockEntityRegistry.NUCLEAR_FURNACE.get()), NuclearFurnaceBlockEntity::tick);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return NuclearFurnaceComponentBlock.isCornerForFurnace(level, pos, false, true);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (!state.m_60710_((LevelReader)levelAccessor, blockPos)) {
            this.checkCriticalityExplosion((LevelReader)levelAccessor, blockPos);
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!player.m_6144_()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (this.m_7898_(state, (LevelReader)level, blockPos)) {
                BlockEntity blockentity = level.m_7702_(blockPos);
                if (blockentity instanceof NuclearFurnaceBlockEntity) {
                    NuclearFurnaceBlockEntity nuclearFurnaceBlockEntity = (NuclearFurnaceBlockEntity)blockentity;
                    player.m_5893_((MenuProvider)nuclearFurnaceBlockEntity);
                    nuclearFurnaceBlockEntity.onPlayerUse(player);
                    player.m_36220_(Stats.f_12966_);
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6240_(Level level, Player player, BlockPos blockPos, BlockState state, @javax.annotation.Nullable BlockEntity entity, ItemStack itemStack) {
        this.checkCriticalityExplosion((LevelReader)level, blockPos);
        super.m_6240_(level, player, blockPos, state, entity, itemStack);
    }

    private void checkCriticalityExplosion(LevelReader level, BlockPos pos) {
        NuclearFurnaceBlockEntity nuclearFurnaceBlockEntity;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof NuclearFurnaceBlockEntity && (float)(nuclearFurnaceBlockEntity = (NuclearFurnaceBlockEntity)blockEntity).getCriticality() >= 2.0f) {
            nuclearFurnaceBlockEntity.destroyWhileCritical(false);
        }
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState1, boolean idk) {
        if (!blockState.m_60713_(blockState1.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(blockPos);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)((Container)blockentity));
                level.m_46717_(blockPos, (Block)this);
            }
            super.m_6810_(blockState, level, blockPos, blockState1, idk);
        }
    }
}

