/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GummyRingBlock
extends DirectionalBlock
implements BucketPickup,
LiquidBlockContainer {
    public static final IntegerProperty LIQUID_LOGGED = IntegerProperty.m_61631_((String)"liquid_logged", (int)0, (int)2);
    public static final BooleanProperty FLOATING = BooleanProperty.m_61465_((String)"floating");
    private static final VoxelShape SHAPE_UP = Shapes.m_83113_((VoxelShape)GummyRingBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)GummyRingBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape SHAPE_UP_FLOATING = Shapes.m_83113_((VoxelShape)GummyRingBlock.m_49796_((double)0.0, (double)-4.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)GummyRingBlock.m_49796_((double)5.0, (double)-4.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape SHAPE_DOWN = Shapes.m_83113_((VoxelShape)GummyRingBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)GummyRingBlock.m_49796_((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83113_((VoxelShape)GummyRingBlock.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)GummyRingBlock.m_49796_((double)5.0, (double)5.0, (double)8.0, (double)11.0, (double)11.0, (double)16.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape SHAPE_SOUTH = Shapes.m_83113_((VoxelShape)GummyRingBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)GummyRingBlock.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)8.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape SHAPE_EAST = Shapes.m_83113_((VoxelShape)GummyRingBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)GummyRingBlock.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)8.0, (double)11.0, (double)11.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape SHAPE_WEST = Shapes.m_83113_((VoxelShape)GummyRingBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)GummyRingBlock.m_49796_((double)8.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), (BooleanOp)BooleanOp.f_82685_);

    public GummyRingBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283913_).m_60978_(2.0f).m_60918_(ACSoundTypes.SQUISHY_CANDY).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(0))).m_61124_((Property)FLOATING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52588_, (Comparable)Direction.UP));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState blockState, boolean forced) {
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        int liquidType = (Integer)state.m_61143_((Property)LIQUID_LOGGED);
        if (liquidType == 1) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        } else if (liquidType == 2) {
            levelAccessor.m_186469_(blockPos, (Fluid)ACFluidRegistry.ACID_FLUID_SOURCE.get(), ((FlowingFluid)ACFluidRegistry.ACID_FLUID_SOURCE.get()).m_6718_((LevelReader)levelAccessor));
        }
        boolean flag = liquidType == 0 && state.m_61143_((Property)f_52588_) == Direction.UP && !levelAccessor.m_6425_(blockPos.m_7495_()).m_76178_();
        return (BlockState)state.m_61124_((Property)FLOATING, (Comparable)Boolean.valueOf(flag));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)f_52588_)) {
            case DOWN: {
                return SHAPE_DOWN;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return (Boolean)state.m_61143_((Property)FLOATING) != false ? SHAPE_UP_FLOATING : SHAPE_UP;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelaccessor = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        int fluid = this.getLiquidType(context.m_43725_().m_6425_(context.m_8083_()));
        Direction facing = context.m_43719_();
        boolean flag = false;
        if (facing == Direction.UP) {
            flag = !levelaccessor.m_6425_(blockpos.m_7495_()).m_76178_() && fluid == 0;
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(fluid))).m_61124_((Property)f_52588_, (Comparable)facing)).m_61124_((Property)FLOATING, (Comparable)Boolean.valueOf(flag));
    }

    private int getLiquidType(FluidState fluidState) {
        if (fluidState.m_76152_() == Fluids.f_76193_) {
            return 1;
        }
        if (fluidState.getFluidType() == ACFluidRegistry.PURPLE_SODA_FLUID_TYPE.get() && fluidState.m_76170_()) {
            return 2;
        }
        return 0;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public FluidState m_5888_(BlockState state) {
        int liquidType = (Integer)state.m_61143_((Property)LIQUID_LOGGED);
        return liquidType == 1 ? Fluids.f_76193_.m_76068_(false) : (liquidType == 2 ? ((FlowingFluid)ACFluidRegistry.PURPLE_SODA_FLUID_SOURCE.get()).m_76068_(false) : super.m_5888_(state));
    }

    public boolean m_6044_(BlockGetter getter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return fluid == Fluids.f_76193_ || fluid.getFluidType() == ACFluidRegistry.PURPLE_SODA_FLUID_TYPE.get();
    }

    public boolean m_7361_(LevelAccessor levelAccessor, BlockPos pos, BlockState blockState, FluidState fluidState) {
        int liquidType = (Integer)blockState.m_61143_((Property)LIQUID_LOGGED);
        if (liquidType == 0) {
            if (!levelAccessor.m_5776_()) {
                if (fluidState.m_76152_() == Fluids.f_76193_) {
                    levelAccessor.m_7731_(pos, (BlockState)blockState.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(1)), 3);
                } else if (fluidState.getFluidType() == ACFluidRegistry.PURPLE_SODA_FLUID_TYPE.get()) {
                    levelAccessor.m_7731_(pos, (BlockState)blockState.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(2)), 3);
                }
                levelAccessor.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)levelAccessor));
            }
            return true;
        }
        return false;
    }

    public ItemStack m_142598_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState state) {
        int liquidType = (Integer)state.m_61143_((Property)LIQUID_LOGGED);
        levelAccessor.m_7731_(blockPos, (BlockState)state.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(0)), 3);
        if (liquidType > 0) {
            return new ItemStack((ItemLike)(liquidType == 1 ? Items.f_42447_ : (ItemLike)ACItemRegistry.PURPLE_SODA_BUCKET.get()));
        }
        return ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{LIQUID_LOGGED, FLOATING, f_52588_});
    }

    public PushReaction getPistonPushReaction(BlockState blockState) {
        return PushReaction.DESTROY;
    }
}

