/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GalenaSpireBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final IntegerProperty SHAPE = IntegerProperty.m_61631_((String)"shape", (int)0, (int)3);
    public static final VoxelShape SHAPE_0 = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape SHAPE_1 = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final VoxelShape SHAPE_2 = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final VoxelShape SHAPE_3_TOP = Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape SHAPE_3_BOTTOM = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);

    public GalenaSpireBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.PURPLE).m_60978_(1.5f).m_60918_(SoundType.f_154677_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SHAPE, (Comparable)Integer.valueOf(3)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.m_60824_(getter, pos);
        VoxelShape shape = SHAPE_0;
        switch ((Integer)state.m_61143_((Property)SHAPE)) {
            case 0: {
                shape = SHAPE_0;
                break;
            }
            case 1: {
                shape = SHAPE_1;
                break;
            }
            case 2: {
                shape = SHAPE_2;
                break;
            }
            case 3: {
                shape = (Boolean)state.m_61143_((Property)DOWN) != false ? SHAPE_3_TOP : SHAPE_3_BOTTOM;
            }
        }
        return shape.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelaccessor = context.m_43725_();
        boolean down = context.m_43719_() == Direction.DOWN;
        BlockPos blockpos = context.m_8083_();
        BlockState above = levelaccessor.m_8055_(blockpos.m_7494_());
        BlockState below = levelaccessor.m_8055_(blockpos.m_7495_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down))).m_61124_((Property)SHAPE, (Comparable)Integer.valueOf(down ? this.getShapeInt(below, above, down) : this.getShapeInt(above, below, down)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_));
    }

    public int getShapeInt(BlockState above, BlockState below, boolean down) {
        if (above.m_60734_() == ACBlockRegistry.TESLA_BULB.get()) {
            return 2;
        }
        if (!GalenaSpireBlock.isGalenaSpireConnectable(above, down)) {
            return 3;
        }
        int aboveShape = (Integer)above.m_61143_((Property)SHAPE);
        if (aboveShape <= 1) {
            boolean connectedUnder = down ? above.m_60734_() != ACBlockRegistry.GALENA_SPIRE.get() : below.m_60734_() != ACBlockRegistry.GALENA_SPIRE.get();
            return connectedUnder ? 0 : 1;
        }
        return aboveShape - 1;
    }

    @Deprecated
    public boolean m_7898_(BlockState state, LevelReader levelAccessor, BlockPos blockPos) {
        BlockState above = levelAccessor.m_8055_(blockPos.m_7494_());
        BlockState below = levelAccessor.m_8055_(blockPos.m_7495_());
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            return above.m_60783_((BlockGetter)levelAccessor, blockPos.m_7494_(), Direction.UP) || GalenaSpireBlock.isGalenaSpireConnectable(above, true);
        }
        return below.m_60783_((BlockGetter)levelAccessor, blockPos.m_7495_(), Direction.DOWN) || GalenaSpireBlock.isGalenaSpireConnectable(below, false);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        BlockState prev;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        BlockState blockState = prev = state.m_60710_((LevelReader)levelAccessor, blockPos) ? super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1) : Blocks.f_50016_.m_49966_();
        if (prev.m_60734_() == this) {
            BlockState above = levelAccessor.m_8055_(blockPos.m_7494_());
            BlockState below = levelAccessor.m_8055_(blockPos.m_7495_());
            boolean down = (Boolean)prev.m_61143_((Property)DOWN);
            int shapeInt = down ? this.getShapeInt(below, above, down) : this.getShapeInt(above, below, down);
            prev = (BlockState)prev.m_61124_((Property)SHAPE, (Comparable)Integer.valueOf(shapeInt));
        }
        return prev;
    }

    public static boolean isGalenaSpireConnectable(BlockState state, boolean down) {
        return state.m_60734_() == ACBlockRegistry.GALENA_SPIRE.get() && (Boolean)state.m_61143_((Property)DOWN) == down;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{SHAPE, DOWN, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

