/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.TeletorModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.entity.living.TeletorEntity;
import com.github.alexthe666.citadel.client.render.LightningBoltData;
import com.github.alexthe666.citadel.client.render.LightningRender;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class TeletorRenderer
extends MobRenderer<TeletorEntity, TeletorModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/teletor.png");
    private static final ResourceLocation TEXTURE_GLOW = new ResourceLocation("alexscaves:textures/entity/teletor_glow.png");
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("alexscaves", "textures/particle/teletor_trail.png");
    private Map<UUID, LightningRender> lightningRenderMap = new HashMap<UUID, LightningRender>();

    public TeletorRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new TeletorModel(), 0.5f);
        this.m_115326_(new LayerGlow());
    }

    protected void scale(TeletorEntity mob, PoseStack matrixStackIn, float partialTicks) {
        matrixStackIn.m_85841_(0.9f, 0.9f, 0.9f);
    }

    public boolean shouldRender(TeletorEntity entity, Frustum camera, double x, double y, double z) {
        if (super.m_5523_((Mob)entity, camera, x, y, z)) {
            return true;
        }
        Entity weapon = entity.getWeapon();
        if (weapon != null) {
            Vec3 vec3 = entity.m_20182_();
            Vec3 vec31 = weapon.m_20182_();
            return camera.m_113029_(new AABB(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_));
        }
        return false;
    }

    public ResourceLocation getTextureLocation(TeletorEntity entity) {
        return TEXTURE;
    }

    public void render(TeletorEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        Entity weapon;
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        double x = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
        float yaw = entityIn.f_20884_ + (entityIn.f_20883_ - entityIn.f_20884_) * partialTicks;
        if (entityIn.hasTrail()) {
            poseStack.m_85836_();
            poseStack.m_85837_(-x, -y, -z);
            this.m_7523_((LivingEntity)entityIn, poseStack, 0.0f, 180.0f, partialTicks);
            Vec3 headModelPos = ((TeletorModel)this.m_7200_()).translateToHead(new Vec3(0.0, (double)-0.4f, 0.0), yaw).m_82490_(-1.0);
            poseStack.m_85837_(headModelPos.f_82479_, headModelPos.f_82480_, headModelPos.f_82481_);
            this.renderTrail(entityIn, 0, partialTicks, poseStack, bufferIn, 0.2f, 0.2f, 0.8f, 0.8f, 240);
            this.renderTrail(entityIn, 1, partialTicks, poseStack, bufferIn, 0.8f, 0.2f, 0.2f, 0.8f, 240);
            poseStack.m_85849_();
        }
        if ((weapon = entityIn.getWeapon()) != null && entityIn.m_6084_() && weapon.m_6084_()) {
            poseStack.m_85836_();
            poseStack.m_85837_(-x, -y, -z);
            this.m_7523_((LivingEntity)entityIn, poseStack, 0.0f, 180.0f, partialTicks);
            Vec3 headModelPos = ((TeletorModel)this.m_7200_()).translateToHead(new Vec3(0.0, (double)-0.4f, 0.0), yaw).m_82490_(-1.0);
            Vec3 fromVec1 = entityIn.getHelmetPosition(0).m_82549_(headModelPos);
            Vec3 fromVec2 = entityIn.getHelmetPosition(1).m_82549_(headModelPos);
            Vec3 toVec = weapon.m_20318_(partialTicks).m_82520_(0.0, (double)(weapon.m_20206_() * 0.5f - 0.1f) + Math.sin(((float)weapon.f_19797_ + partialTicks) * 0.1f) * (double)0.1f, 0.0);
            int segCount = Mth.m_14045_((int)((int)weapon.m_20270_((Entity)entityIn) + 2), (int)3, (int)30);
            float spreadFactor = Mth.m_14036_((float)((10.0f - weapon.m_20270_((Entity)entityIn)) / 10.0f * 0.2f), (float)0.01f, (float)0.2f);
            LightningBoltData.BoltRenderInfo blueBoltData = new LightningBoltData.BoltRenderInfo(0.0f, spreadFactor, 0.0f, 0.0f, new Vector4f(0.2f, 0.2f, 0.8f, 0.8f), 0.1f);
            LightningBoltData.BoltRenderInfo redBoltData = new LightningBoltData.BoltRenderInfo(0.0f, spreadFactor, 0.0f, 0.0f, new Vector4f(0.8f, 0.2f, 0.2f, 0.8f), 0.1f);
            LightningBoltData bolt1 = new LightningBoltData(blueBoltData, fromVec1, toVec, segCount).size(0.1f).lifespan(1).spawn(LightningBoltData.SpawnFunction.CONSECUTIVE).fade(LightningBoltData.FadeFunction.NONE);
            LightningBoltData bolt2 = new LightningBoltData(redBoltData, fromVec2, toVec, segCount).size(0.1f).lifespan(1).spawn(LightningBoltData.SpawnFunction.CONSECUTIVE).fade(LightningBoltData.FadeFunction.NONE);
            LightningRender lightningRender = this.getLightingRender(entityIn.m_20148_());
            lightningRender.update((Object)entityIn, bolt1, partialTicks);
            lightningRender.update((Object)weapon, bolt2, partialTicks);
            lightningRender.render(partialTicks, poseStack, bufferIn);
            poseStack.m_85849_();
        }
        if (!entityIn.m_6084_() && this.lightningRenderMap.containsKey(entityIn.m_20148_())) {
            this.lightningRenderMap.remove(entityIn.m_20148_());
        }
    }

    private LightningRender getLightingRender(UUID uuid) {
        if (this.lightningRenderMap.get(uuid) == null) {
            this.lightningRenderMap.put(uuid, new LightningRender());
        }
        return this.lightningRenderMap.get(uuid);
    }

    private void renderTrail(TeletorEntity entityIn, int side, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, float trailR, float trailG, float trailB, float trailA, int packedLightIn) {
        int sampleSize = 10;
        float trailHeight = 0.2f;
        float trailZRot = 0.0f;
        Vec3 topAngleVec = new Vec3(0.0, (double)trailHeight, 0.0).m_82535_(trailZRot);
        Vec3 bottomAngleVec = new Vec3(0.0, (double)(-trailHeight), 0.0).m_82535_(trailZRot);
        Vec3 drawFrom = entityIn.getTrailPosition(0, side, partialTicks);
        VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)TRAIL_TEXTURE));
        for (int samples = 0; samples < sampleSize; ++samples) {
            Vec3 sample = entityIn.getTrailPosition(samples + 2, side, partialTicks);
            float u1 = (float)samples / (float)sampleSize;
            float u2 = u1 + 1.0f / (float)sampleSize;
            Vec3 draw1 = drawFrom;
            Vec3 draw2 = sample;
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)bottomAngleVec.f_82479_, (float)draw1.f_82480_ + (float)bottomAngleVec.f_82480_, (float)draw1.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u1, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw2.f_82479_ + (float)bottomAngleVec.f_82479_, (float)draw2.f_82480_ + (float)bottomAngleVec.f_82480_, (float)draw2.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u2, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw2.f_82479_ + (float)topAngleVec.f_82479_, (float)draw2.f_82480_ + (float)topAngleVec.f_82480_, (float)draw2.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u2, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)topAngleVec.f_82479_, (float)draw1.f_82480_ + (float)topAngleVec.f_82480_, (float)draw1.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u1, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            drawFrom = sample;
        }
    }

    class LayerGlow
    extends RenderLayer<TeletorEntity, TeletorModel> {
        public LayerGlow() {
            super((RenderLayerParent)TeletorRenderer.this);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, TeletorEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(ACRenderTypes.getEyesAlphaEnabled(TEXTURE_GLOW));
            float alpha = (float)(1.0 + Math.sin(ageInTicks * 0.3f)) * 0.1f + 0.8f;
            ((TeletorModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, alpha);
        }
    }
}

