/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.SeaPigModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.CustomBookEntityRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.SeaPigEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class SeaPigRenderer
extends MobRenderer<SeaPigEntity, SeaPigModel>
implements CustomBookEntityRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/sea_pig.png");
    private static final ResourceLocation TEXTURE_INNARDS = new ResourceLocation("alexscaves:textures/entity/sea_pig_innards.png");
    private boolean sepia = false;

    public SeaPigRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new SeaPigModel(), 0.4f);
        this.m_115326_(new LayerOutside(renderManagerIn.m_234598_()));
    }

    public ResourceLocation getTextureLocation(SeaPigEntity entity) {
        return TEXTURE_INNARDS;
    }

    @Nullable
    protected RenderType getRenderType(SeaPigEntity seaPig, boolean normal, boolean translucent, boolean outline) {
        return this.sepia ? ACRenderTypes.getBookWidget(TEXTURE_INNARDS, true) : super.m_7225_((LivingEntity)seaPig, normal, translucent, outline);
    }

    @Override
    public void setSepiaFlag(boolean sepiaFlag) {
        this.sepia = sepiaFlag;
    }

    class LayerOutside
    extends RenderLayer<SeaPigEntity, SeaPigModel> {
        private ItemInHandRenderer itemInHandRenderer;

        public LayerOutside(ItemInHandRenderer itemInHandRenderer) {
            super((RenderLayerParent)SeaPigRenderer.this);
            this.itemInHandRenderer = itemInHandRenderer;
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, SeaPigEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.isDigesting()) {
                ItemStack itemStack = entitylivingbaseIn.m_21120_(InteractionHand.MAIN_HAND);
                float progress = entitylivingbaseIn.getDigestProgress(partialTicks);
                float invProgress = 1.0f - progress;
                matrixStackIn.m_85836_();
                ((SeaPigModel)this.m_117386_()).translateToBody(matrixStackIn);
                matrixStackIn.m_252880_(0.0f, 0.25f - invProgress * 0.1f, -0.5f + progress * 0.2f);
                matrixStackIn.m_85841_(invProgress, invProgress, invProgress);
                matrixStackIn.m_252781_(Axis.f_252495_.m_252977_(200.0f));
                matrixStackIn.m_252781_(Axis.f_252393_.m_252977_((float)(Math.sin(progress * 15.0f) * 4.0)));
                this.itemInHandRenderer.m_269530_((LivingEntity)entitylivingbaseIn, itemStack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
                matrixStackIn.m_85849_();
            }
            VertexConsumer ivertexbuilder1 = bufferIn.m_6299_(SeaPigRenderer.this.sepia ? ACRenderTypes.getBookWidget(TEXTURE, true) : RenderType.m_110473_((ResourceLocation)TEXTURE));
            ((SeaPigModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder1, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

