/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.ClientProxy;
import com.github.alexmodguy.alexscaves.client.model.TubeWormModel;
import com.github.alexmodguy.alexscaves.server.block.TubeWormBlock;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TubeWormParticle
extends Particle {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/particle/tube_worm.png");
    private static final TubeWormModel MODEL = new TubeWormModel();
    private BlockPos blockPos;
    private int checkScareCooldown;
    private float tuckAmount;
    private float prevTuckAmount;
    private float yRot;
    private float animationOffset;
    private boolean scared;

    protected TubeWormParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.f_107226_ = 0.0f;
        this.f_107225_ = 90 + this.f_107223_.m_188503_(50);
        this.m_107250_(0.6f, 1.5f);
        this.blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        this.animationOffset = ACMath.sampleNoise3D((int)x, (int)y, (int)z, 6.0f);
        this.checkScareCooldown = 5 + this.f_107223_.m_188503_(10);
        this.tuckAmount = 1.0f;
        this.prevTuckAmount = 1.0f;
        this.yRot = Direction.m_122407_((int)(2 + this.f_107223_.m_188503_(3))).m_122435_();
    }

    public boolean shouldCull() {
        return false;
    }

    public void m_5989_() {
        super.m_5989_();
        this.prevTuckAmount = this.tuckAmount;
        if (this.checkScareCooldown-- <= 0) {
            this.checkScareCooldown = 10 + this.f_107223_.m_188503_(10);
            Vec3 vec3 = Vec3.m_82512_((Vec3i)this.blockPos);
            AABB scareBox = new AABB(vec3.m_82520_(-5.0, -1.5, -5.0), vec3.m_82520_(5.0, 3.0, 5.0));
            this.scared = !this.f_107208_.m_45976_(LivingEntity.class, scareBox).isEmpty();
        }
        BlockState state = this.f_107208_.m_8055_(this.blockPos);
        float targetTuckAmount = this.scared || this.f_107224_ >= this.f_107225_ - 10 || !state.m_60819_().m_205070_(FluidTags.f_13131_) || !this.f_107208_.m_6425_(this.blockPos.m_7494_()).m_205070_(FluidTags.f_13131_) ? 1.0f : 0.0f;
        if (this.tuckAmount < targetTuckAmount) {
            this.tuckAmount = Math.min(targetTuckAmount, this.tuckAmount + 0.1f);
        }
        if (this.tuckAmount > targetTuckAmount) {
            this.tuckAmount = Math.max(targetTuckAmount, this.tuckAmount - 0.1f);
        }
        if (!TubeWormBlock.canSupportWormAt((Level)this.f_107208_, state, this.blockPos)) {
            this.m_107274_();
        }
    }

    public void m_107274_() {
        super.m_107274_();
        ((ClientProxy)AlexsCaves.PROXY).removeParticleAt(this.blockPos);
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Vec3 vec3 = camera.m_90583_();
        float scale = 1.0f;
        float f = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        float lerpedTuck = this.prevTuckAmount + (this.tuckAmount - this.prevTuckAmount) * partialTick;
        PoseStack posestack = new PoseStack();
        posestack.m_85836_();
        posestack.m_252880_(f, f1 + 1.0f, f2);
        posestack.m_85841_(-scale, -scale, scale);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        MODEL.animateParticle(this.f_107224_, lerpedTuck, this.animationOffset, this.yRot, partialTick);
        VertexConsumer baseConsumer = multibuffersource$buffersource.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        MODEL.m_7695_(posestack, baseConsumer, this.m_6355_(partialTick), OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        multibuffersource$buffersource.m_109911_();
        posestack.m_85849_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new TubeWormParticle(worldIn, x, y, z);
        }
    }
}

