/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexthe666.citadel.client.render.LightningBoltData;
import com.github.alexthe666.citadel.client.render.LightningRender;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector4f;

public class QuarryBorderLightningParticle
extends Particle {
    private LightningRender lightningRender = new LightningRender();
    private static final Vector4f LIGHTNING_COLOR = new Vector4f(0.71f, 0.76f, 0.95f, 0.3f);

    public QuarryBorderLightningParticle(ClientLevel world, double x, double y, double z, double xd, double yd, double zd) {
        super(world, x, y, z);
        this.m_107250_(6.0f, 6.0f);
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        Vec3 lightningTo = new Vec3(xd - x, yd - y, zd - z);
        this.f_107225_ = 5;
        int sections = (int)(4.0 * lightningTo.m_82553_());
        LightningBoltData.BoltRenderInfo boltData = new LightningBoltData.BoltRenderInfo(0.015f, 0.025f, 0.0f, 0.0f, LIGHTNING_COLOR, 0.7f);
        LightningBoltData bolt = new LightningBoltData(boltData, Vec3.f_82478_, lightningTo, sections).size(0.1f + this.f_107223_.m_188501_() * 0.1f).lifespan(this.f_107225_).spawn(LightningBoltData.SpawnFunction.NO_DELAY);
        this.lightningRender.update((Object)this, bolt, 1.0f);
    }

    public boolean shouldCull() {
        return false;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107216_ -= (double)this.f_107226_;
        }
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTick) {
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 cameraPos = camera.m_90583_();
        float x = (float)Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_);
        float y = (float)Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_);
        float z = (float)Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_);
        PoseStack posestack = new PoseStack();
        posestack.m_85836_();
        posestack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        posestack.m_252880_(x, y, z);
        this.lightningRender.render(partialTick, posestack, (MultiBufferSource)multibuffersource$buffersource);
        multibuffersource$buffersource.m_109911_();
        posestack.m_85849_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new QuarryBorderLightningParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

