/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.render.entity.ForsakenRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.ForsakenEntity;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ForsakenSpitParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private int onGroundTime;
    private final int forsakenId;
    private Vec3 inMouthOffset;

    protected ForsakenSpitParticle(ClientLevel level, double x, double y, double z, int forsakenId, SpriteSet sprites) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_172258_ = 0.96f;
        this.f_107226_ = 0.0f;
        this.f_172259_ = true;
        this.sprites = sprites;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107663_ *= 0.8f + this.f_107223_.m_188501_() * 0.5f;
        this.f_107225_ = 100 + this.f_107223_.m_188503_(40);
        this.f_107225_ = Math.max(this.f_107225_, 1);
        this.m_108339_(sprites);
        this.f_107219_ = true;
        this.forsakenId = forsakenId;
        this.inMouthOffset = new Vec3(this.f_107223_.m_188499_() ? (double)0.3f : (double)-0.3f, -0.0, (double)(this.f_107223_.m_188501_() * 0.7f - 0.2f));
        this.setInMouthPos(1.0f);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107230_ = 0.5f;
    }

    public float m_5902_(float f) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + f) / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.isInMouth()) {
            this.f_107226_ = 0.0f;
            this.f_107215_ = 0.0;
            this.f_107216_ = 0.0;
            this.f_107217_ = 0.0;
            this.setInMouthPos(1.0f);
        } else {
            this.f_107226_ = 1.0f;
            if (this.f_107218_) {
                ++this.onGroundTime;
            }
        }
        int sprite = this.f_107218_ ? 1 : 0;
        this.m_108337_(this.sprites.m_5819_(sprite, 1));
        if (this.onGroundTime > 5) {
            this.m_107274_();
        }
    }

    public boolean isInMouth() {
        return (float)this.f_107224_ < (float)this.f_107225_ * 0.25f;
    }

    public void setInMouthPos(float partialTick) {
        Entity entity;
        if (this.forsakenId != -1 && (entity = this.f_107208_.m_6815_(this.forsakenId)) instanceof ForsakenEntity) {
            ForsakenEntity entity2 = (ForsakenEntity)entity;
            Vec3 mouthPos = ForsakenRenderer.getMouthPositionFor(this.forsakenId);
            if (mouthPos != null) {
                Vec3 translate = mouthPos.m_82549_(this.inMouthOffset).m_82524_((float)(Math.PI - (double)(entity2.f_20883_ * ((float)Math.PI / 180))));
                this.m_107264_(entity2.m_20185_() + translate.f_82479_, entity2.m_20186_() + translate.f_82480_, entity2.m_20189_() + translate.f_82481_);
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ForsakenSpitParticle particle = new ForsakenSpitParticle(worldIn, x, y, z, (int)xSpeed, this.spriteSet);
            return particle;
        }
    }
}

