/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy.listeners;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityDied;
import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.undeadarmy.UndeadArmyConfig;
import com.majruszsdifficulty.undeadarmy.UndeadArmyHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class UndeadArmyTrigger {
    private static void update(OnEntityDied data) {
        Player player = (Player)data.attacker;
        Serializables.modify((Object)new Progress(), (Tag)EntityHelper.getOrCreateExtraTag((Entity)player), progress -> {
            --progress.undeadLeft;
            if (progress.undeadLeft <= 0 && UndeadArmyHelper.tryToSpawn(player)) {
                progress.undeadLeft = UndeadArmyConfig.KILL_REQUIREMENT;
            } else if (progress.undeadLeft == UndeadArmyConfig.KILL_REQUIREMENT_WARNING) {
                player.m_213846_((Component)TextHelper.translatable((String)"majruszsdifficulty.undead_army.warning", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE));
            }
        });
    }

    static {
        OnEntityDied.listen(UndeadArmyTrigger::update).addCondition(data -> UndeadArmyConfig.KILL_REQUIREMENT > 0).addCondition(data -> data.target.m_6336_() == MobType.f_21641_).addCondition(data -> !UndeadArmyHelper.isPartOfUndeadArmy((Entity)data.target)).addCondition(data -> data.attacker instanceof ServerPlayer).addCondition(data -> EntityHelper.isIn((Entity)data.attacker, (ResourceKey)Level.f_46428_));
        Serializables.get(Progress.class).define("UndeadArmyUndeadLeft", Reader.integer(), s -> s.undeadLeft, (s, v) -> {
            s.undeadLeft = v;
        });
    }

    public static class Progress {
        public int undeadLeft = UndeadArmyConfig.KILL_REQUIREMENT_FIRST;
    }
}

